import express, { Request, Response } from 'express';
import { indexHTMLProvider } from 'services/IndexHTMLProvider';
import { RequestError } from 'got';
import asyncHandler from 'express-async-handler';
import { getPatchedInfo } from 'routes/info';

export const router = express.Router();

router.get('/', asyncHandler(async(req: Request, res: Response) => {
    let info = {};
    let error = null;
    try {
        info = await getPatchedInfo(req);
    } catch (requestError) {
        const gotError = requestError as RequestError;

        error = { code: gotError.code, name: gotError.name, message: gotError.message };
    }

    res.send(indexHTMLProvider.html
        .replace(/<!--##NoncePlaceholder-->/g, req.nonce)
        .replace(/<!--##ConfigPlaceholder-->/g, JSON.stringify({ nonce: req.nonce, info, error })));
}));

router.get(['/index.html', '/space', '/space/index.html'], (req, res) => {
    res.redirect('/');
});
