import express, { Request, Response } from 'express';
import asyncHandler from 'express-async-handler';

export const getPatchedInfo = async(req: Request) => {
    // one place for patch /info response, useless for now
    const data = (await req.backendClients.crm.get('info').json() || {}) as Record<string, unknown>;

    return data;
};

export const router = express.Router();

router.get('/info', asyncHandler(async(req: Request, res: Response) => {
    const data = await getPatchedInfo(req);

    res.send(data);
}));
