import { exponentialBuckets } from '@yandex-data-ui/monlib-nodejs';
import { LoggerMode } from '../Config.types';

export class Config {
    public static LoggerMode = LoggerMode;

    private static instance: Config | null = null;

    static getInstance() {
        if (Config.instance) {
            return Config.instance;
        }

        return Config.instance = new Config();
    }

    readonly pathToStatic = 'http://s3.mds.yandex.net/crm-public/dist/2.161.0.191';
    readonly bunkerApiUrl = 'http://bunker-api-dot.yandex.net/v1';
    readonly tvmApiUrl = 'http://localhost:8001';
    readonly tvmApiToken = 'tvmtool-development-access-token';
    readonly crmBackendApiUrl = 'http://crm.backend';
    readonly crmAppUrl = 'http://crm.app';
    readonly loggerMode: LoggerMode = LoggerMode.Line;

    readonly appKey = 'appKey';

    readonly delegationIdCookieName = 'delegationId';
    readonly delegationIdHeaderName = 'X-Crm-Delegation-Id';

    readonly devLoginCookieName = 'devcrm';
    readonly devLoginHeaderName = 'X-Crm-Dev-Login';

    readonly kibanaLogPath = '';

    readonly isLocalEnv: boolean = false;

    readonly devUserIp = '';

    readonly useDevUserIpUrl = false;
    readonly devUserIpUrl = '';

    /**
     * По-умолчанию для реквестов создаем бакеты от 16мс до 131072мс
     * Все что выполнялось дольше будет записано в бакет +inf
     */
    readonly DEFAULT_REQUEST_DURATION_BUCKETS = exponentialBuckets(16, 2, 14);

    constructor() {}
}
