import { Options, RequestError, Response } from 'got';
import { Logger } from '@yandex-int/yandex-logger';
import { secureCRMHeaders } from 'utils/secureCRMHeaders';

export class GotLogger {
    constructor(private name: string, private logger: Logger) {}

    logRequest(options: Options) {
        this.logger.info(this.createRequestSecurePayload(options), `${this.name}: request %s`, options.url);
    }

    logResponse(response: Response) {
        this.logger.info(`${this.name}: response %s %s`, response.url, response.statusCode);
    }

    logError(error: RequestError) {
        this.logger.error(this.createErrorSecurePayload(error));
    }

    private createRequestSecurePayload(options: Options) {
        return { request: this.getNeededOptions(options) };
    }

    private createErrorSecurePayload(error: RequestError) {
        return { err: {
            name: error.name,
            message: error.message,
            code: error.code,
            stack: error.stack,
        } };
    }

    private getNeededOptions(options: Options) {
        const record = {
            headers: secureCRMHeaders(options.headers),
            body: options.body,
            url: options.url,
        };

        return record;
    }
}
