import got from 'got';
import { Config } from 'services/Config';

export class IndexHTMLProvider {
    private _html = '';
    private _version = '';

    async load(): Promise<void> {
        try {
            await Promise.all([this.loadIndex(), this.loadVersion()]);
        } catch (error) {
            console.error(error);

            throw error;
        }
    }

    get html(): string {
        return this._html;
    }

    get version(): string {
        return this._version;
    }

    private async loadIndex() {
        this._html = await this.loadFileContent('index.html');

        return this._html;
    }

    private async loadVersion() {
        this._version = await this.loadFileContent('frontend.version');

        return this._version;
    }

    private async loadFileContent(filename: string): Promise<string> {
        const config = Config.getInstance();

        const content = await got(`${config.pathToStatic}/${filename}`).text();

        return content;
    }
}
