import { WriteStream } from 'fs';
import { join } from 'path';
import FileStreamRotator from 'file-stream-rotator';
import stringify from 'json-stringify-safe';
import { KibanaLogDTO } from 'typings/KibanaLogDTO';

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export const recordToKibanaLogDTO = (record: any): KibanaLogDTO => {
    return {
        // move from message to context after fix for https://st.yandex-team.ru/CRM-18725
        message: stringify(record, undefined, 4),
        levelStr: record.levelName,
        loggerName: 'common',
        request_id: record.requestId,
        user_id: record?.user?.login,
        process_id: Number(record.requestIdByClient) || 0,
        Host: process.env.DEPLOY_POD_TRANSIENT_FQDN ?? '',
        timestamp: Number(record.date),
    };
};

export interface CreateKibanaLogStreamOptions {
    path: string;
}

export const createKibanaLogStream = ({ path }: CreateKibanaLogStreamOptions) => {
    const stream: WriteStream = FileStreamRotator.getStream({
        filename: join(path, '/file-%DATE%'),
        audit_file: join(path, '/audit.json'),
        frequency: '1h',
        date_format: 'YYYY-MM-DD-HH',
        verbose: false,
        max_logs: 10,
        size: '100m',
        extension: '.log',
    });

    return {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        write(record: any) {
            stream.write(stringify(recordToKibanaLogDTO(record)) + '\n');
        },
    };
};
