import { networkInterfaces } from 'os';

const YANDEX_NETWORK_ADDRESS_STARTS_WITH = '2a02:6b8';

export const getLocalDevYandexRealIp = (): string | undefined => {
    const networkAddress = Object.values(networkInterfaces())
        .flat()
        .find(networkAddress =>
            networkAddress && networkAddress.address.startsWith(YANDEX_NETWORK_ADDRESS_STARTS_WITH)
        );

    return networkAddress && networkAddress.address;
};
