import { Response } from 'express';
import { Disposable } from 'typings/Disposable';

export const runAfterResponseSended = (res: Response, callback: () => void): Disposable['dispose'] => {
    const dispose = () => {
        res.removeListener('close', onResponseEnd);
        res.removeListener('finish', onResponseEnd);
    };

    const onResponseEnd = () => {
        dispose();
        callback();
    };

    res.on('close', onResponseEnd);
    res.on('finish', onResponseEnd);

    return dispose;
};
