import { Headers } from 'got';
import securePassportCookie from '@yandex-int/yandex-logger/middleware/secure-passport-cookie';
import secureTvmHeaders from '@yandex-int/yandex-logger/middleware/secure-tvm-headers';

export { Headers } from 'got';

export const secureCRMHeaders = (headers: Headers): Headers => {
    const record = { headers };

    securePassportCookie({ field: 'headers.cookie' })(record);
    secureTvmHeaders({ field: 'headers' })(record);

    return record.headers;
};
