import { validateOrReject as validateOrRejectBase, ValidatorOptions, ValidationError } from 'class-validator';
import { ClassValidatorError } from 'models/ClassValidatorError';

export const validateOrReject = async(object: object, validatorOptions?: ValidatorOptions): Promise<void> => {
    try {
        await validateOrRejectBase(object, validatorOptions);
    } catch (errors) {
        throw new ClassValidatorError(errors as ValidationError[]);
    }
};
