const path = require('path');
const webpack = require('webpack');
const { getCert } = require('@yandex-int/yandex-internal-cert');

module.exports = {
    target: 'node',
    mode: process.env.NODE_ENV,
    entry: process.env.IS_LOCAL_ENV ? './src/index.dev.ts' : './src/index.ts',
    module: {
        rules: [
            {
                test: /\.html$/i,
                type: 'asset/source',
            },
            {
                test: /\.tsx?$/,
                use: 'ts-loader',
                exclude: /node_modules/,
            },
        ],
    },
    resolve: {
        modules: [
            path.resolve(__dirname, 'src'),
            'node_modules',
        ],
        extensions: ['.tsx', '.ts', '.js', '.json'],
    },
    output: {
        filename: 'index.js',
        path: path.resolve(__dirname, 'dist'),
    },
    plugins: [
        new webpack.DefinePlugin({
            CA: JSON.stringify(String(getCert())),
        }),
    ],
};
