import logging
import os
import sys

from aiohttp import web

from crm.infra.github_webhook.views.ping import handle_ping
from crm.infra.github_webhook.views.pr import handle_bb_webhook, handle_github_webhook

from library.python.deploy_formatter import DeployFormatter


log_formatter = DeployFormatter()

errors_handler = logging.StreamHandler(sys.stderr)
errors_handler.setLevel(logging.WARN)
errors_handler.setFormatter(log_formatter)
others_handler = logging.StreamHandler(sys.stdout)
others_handler.setLevel(logging.DEBUG)
others_handler.addFilter(lambda record: record.levelno <= logging.INFO)
others_handler.setFormatter(log_formatter)

root = logging.getLogger()
root.setLevel(logging.INFO)
root.addHandler(errors_handler)
root.addHandler(others_handler)

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)


def main():
    app = web.Application()
    logging.basicConfig(level=logging.DEBUG)

    app.router.add_post('/bb/pr', handle_bb_webhook)
    app.router.add_post('/github/pr/merge', handle_github_webhook)
    app.router.add_get('/ping', handle_ping)

    web.run_app(app, port=os.getenv('PORT') or 80)


if __name__ == "__main__":
    main()
