import functools
import logging

from aiohttp import web

from crm.infra.github_webhook.utils.signature import check_sha256_signature


logger = logging.getLogger(__name__)


def signed_event(func):
    @functools.wraps(func)
    async def wrapper(request):
        if not await check_sha256_signature(request):
            return web.Response(status=401, text='unauthorized')

        return await func(request)
    return wrapper
