from aiohttp import web

from crm.infra.github_webhook.pr_events.base import signed_event
from crm.infra.github_webhook.utils.bb import PullRequestInfo
from crm.infra.github_webhook.utils.slack import post_message


@signed_event
async def process_added_comment(request):
    body = await request.json()
    comment = body['comment']['text']
    info = PullRequestInfo(body['pullRequest'])

    if comment.strip() == '/ping':
        message_text = f':mag: {info.author_name} призвал тебя посмотреть на пул-реквест\n'
    elif comment.strip() == '/fixed':
        message_text = f':mag: {info.author_name} исправил замечания в пул-реквесте\n'
    else:
        return web.Response(status=200)

    for reviewer in info.not_approved_yet:
        await post_message(reviewer, message_text + info.link)

    return web.Response(status=200)
