from aiohttp import web

from crm.infra.github_webhook.pr_events.base import signed_event
from crm.infra.github_webhook.utils.st import get_tickets, execute_transitions


@signed_event
async def process_merged_pr(request):
    body = await request.json()
    pull_request = body['pullRequest']
    if not pull_request['state'] == 'MERGED':
        return web.Response(status=400)

    tickets = get_tickets(
        pull_request['title'],
        pull_request.get('description') or '',
        pull_request['fromRef']['id']
    )

    errors = await execute_transitions(tickets)
    if not errors:
        errors = web.Response(status=200)
    return errors
