def get_diff_summary(diff: str):
    diff_lines = diff.splitlines()

    file_indexes = []
    for i in range(len(diff_lines)):
        if diff_lines[i].startswith('diff'):
            file_indexes.append(i)

    file_indexes.append(len(diff_lines))

    skip_words = [
        '.generated.cs',
        '.designer.cs',
        '.csproj',
        '.sln'
    ]

    pluses = 0
    minuses = 0
    for file_index in range(len(file_indexes) - 1):
        start_file_diff = file_indexes[file_index]
        end_file_diff = file_indexes[file_index + 1]

        if any([skip_word in diff_lines[start_file_diff].lower() for skip_word in skip_words]):
            continue

        for line_index in range(start_file_diff, end_file_diff):
            if diff_lines[line_index].startswith('+++') or diff_lines[line_index].startswith('---'):
                continue

            if diff_lines[line_index] == '+' or diff_lines[line_index] == '-' :
                continue

            if diff_lines[line_index].startswith('+'):
                pluses += 1

            if diff_lines[line_index].startswith('-'):
                minuses += 1

    return pluses, minuses
