import asyncio
import logging
import os

from time import time

import aiohttp


logger = logging.getLogger(__name__)

SYNC_USERS_LOCK = asyncio.Lock()
SYNC_USERS_INTERVAL = 10 * 60  # 10 min
SLACK_TOKEN = os.getenv('SLACK_TOKEN')
SLACK_BASE_URI = 'https://slack.com/api/'

SLACK_USERS = {
    'last_sync': None,
    'users': {}
}


async def sync_users():
    last_sync = SLACK_USERS['last_sync']
    if last_sync and time() - last_sync < SYNC_USERS_INTERVAL:
        logging.debug('skip syncing slack users')
        return

    async with aiohttp.ClientSession(headers={'Authorization': f'Bearer {SLACK_TOKEN}'}) as session:
        SLACK_USERS['users'].clear()

        has_more = True
        cursor = ''
        while has_more:
            async with session.get(
                SLACK_BASE_URI + 'users.list',
                params={'cursor': cursor, 'limit': 50}
            ) as resp:
                logging.debug('get users')
                result = await resp.json()
                for member in result['members']:
                    SLACK_USERS['users'][member['name']] = member['id']

                cursor = result['response_metadata']['next_cursor']
                has_more = cursor != ''
            if has_more:
                logging.debug('get more users')

    SLACK_USERS['last_sync'] = time()


async def post_message(user, message):
    async with SYNC_USERS_LOCK:
        await sync_users()

        logger.info(f'posting message to {user}')
        if os.getenv('DEBUG_MODE', False):
            recepient = SLACK_USERS['users'][user]
            message = f'Это тест, если тебе это пришло, скажи Буторину\nСообщение для {user}: {recepient}\n\n' + message
            user = 'butorin'
            logger.debug('redirect to butorin')

        async with aiohttp.ClientSession(headers={'Authorization': f'Bearer {SLACK_TOKEN}'}) as session:
            data = {
                'channel': SLACK_USERS['users'][user],
                'text': message
            }

            await session.post(SLACK_BASE_URI + "chat.postMessage", data=data)
