import os
import re

import aiohttp

from aiohttp import web


def get_tickets(title, description, branch):
    return list(
        set(
            re.findall(r'CRM-\d+', title) +
            re.findall(r'CRM-\d+', description) +
            re.findall(r'CRM-\d+', branch)
        )
    )


async def execute_transitions(tickets):
    st_token = os.environ['ST_TOKEN']
    attrs_template = 'https://st-api.yandex-team.ru/v2/issues/{}'
    transition_template = 'https://st-api.yandex-team.ru/v2/issues/{}/transitions/resolved/_execute'
    async with aiohttp.ClientSession(headers={
        'Authorization': f'OAuth {st_token}'
    }) as session:
        for ticket in tickets:
            attts_url = attrs_template.format(ticket)
            async with session.get(attts_url) as resp:
                attrs = await resp.json()
                if attrs['status']['key'] != 'codeReview':
                    continue

            transition_url = transition_template.format(ticket)
            async with session.post(transition_url, json={'resolution': 'fixed'}) as resp:
                resp_json = await resp.json()
                status_code = 200 if 'statusCode' not in resp_json else resp_json['statusCode']
                if status_code != 200:
                    return web.json_response(resp_json, status=status_code)
