package ru.yandex.crm.infra.jooq.generator

import org.jooq.codegen.GenerationTool
import org.jooq.meta.jaxb.Configuration
import org.jooq.meta.jaxb.Database
import org.jooq.meta.jaxb.Generate
import org.jooq.meta.jaxb.Generator
import org.jooq.meta.jaxb.Logging
import org.jooq.meta.jaxb.OnError
import org.jooq.meta.jaxb.Property
import org.jooq.meta.jaxb.Target

class JooqGenerator(private val generatorConfiguration: GeneratorConfiguration) {
    fun generate() {
        val configuration = createJooqConfiguration()
        GenerationTool.generate(configuration)
    }

    private fun createJooqConfiguration(): Configuration {
        val jooqDatabase = Database()
            .withName("org.jooq.meta.extensions.liquibase.LiquibaseDatabase")
            .withProperties(
                Property()
                    .withKey("rootPath")
                    .withValue(generatorConfiguration.arcadiaRootPath),
                Property()
                    .withKey("scripts")
                    .withValue(generatorConfiguration.changelogFilePath),
                Property()
                    .withKey("database.defaultSchemaName")
                    .withValue(generatorConfiguration.defaultSchemaName),
                Property()
                    .withKey("database.liquibaseSchemaName")
                    .withValue(generatorConfiguration.liquibaseSchemaName),
                Property()
                    .withKey("database.contexts")
                    .withValue(generatorConfiguration.liquibaseContexts ?: "none")
            )
        val target = Target()
            .withPackageName("ru.yandex.crm.generated.database.${generatorConfiguration.defaultSchemaName}")
            .withClean(true)
            .withDirectory(generatorConfiguration.buildRoot)
        val generate = Generate()
            .withKotlinSetterJvmNameAnnotationsOnIsPrefix(true)
            .withPojosAsKotlinDataClasses(true)
            .withPojos(true)
            .withDaos(true)
        val generator = Generator()
            .withName("org.jooq.codegen.KotlinGenerator")
            .withDatabase(jooqDatabase)
            .withTarget(target)
            .withGenerate(generate)
        return Configuration()
            .withGenerator(generator)
            .withLogging(Logging.INFO)
            .withOnError(OnError.FAIL)
    }
}
