const kibanaMetadata = JSON.parse(document.querySelector('kbn-injected-metadata').getAttribute('data'));
const indexIdRegExp = new RegExp('index:\'(.*?)\'');
const stringCollator = new Intl.Collator(undefined, {sensitivity: 'accent'});
const subtreeChildOptions = {
    subtree: true,
    childList: true
};

if (kibanaMetadata['branch'] === '7.14') {
    patchDiscoverApp();
    patchLoginPage();
}

function patchDiscoverApp() {
    const onNewTableLoaded = getWaitNodeCallback(
        node => node.classList !== undefined && node.classList.contains('euiDataGridRowCell--datetime'),
        node => {
            const smile = document.createElement('a');
            smile.innerText = '😁';
            smile.addEventListener('click', () => onSmileClick(smile.parentElement.parentElement.nextElementSibling.querySelector('span').textContent));
            const contentDiv = node.firstElementChild;
            contentDiv.insertBefore(smile, contentDiv.firstElementChild);
        },
        false
    );

    const onOldTableLoaded = getWaitNodeCallback(
        node => node.classList !== undefined && node.classList.contains('kbnDocTable__row'),
        node => {
            const smile = document.createElement('a');
            smile.innerText = '😁';
            smile.addEventListener('click', () => onSmileClick(smile.parentElement.nextElementSibling.textContent));
            const contentDiv = node.children[1];
            contentDiv.insertBefore(smile, contentDiv.firstElementChild);
        },
        false
    );

    const onDiscoverAppLoaded = getWaitNodeCallback(
        node => stringCollator.compare(node.nodeName, 'discover-app') === 0,
        node => {
            const table = node.querySelector('.euiPanel');
            new MutationObserver(onNewTableLoaded).observe(table, subtreeChildOptions);
            new MutationObserver(onOldTableLoaded).observe(table, subtreeChildOptions);
        },
        false
    );

    new MutationObserver(onDiscoverAppLoaded).observe(document.body, subtreeChildOptions);

    function onSmileClick(requestId) {
        const indexMatch = indexIdRegExp.exec(window.location.hash);
        if (indexMatch === null) {
            console.log('Unable to detect index id');
            return;
        }
        const index = indexMatch[1];
        const params = new URLSearchParams(window.location.hash.substr(3));
        const g = params.get('_g');
        const a = [
            'columns:!(LineNumber,Mode,Login,Message)',
            `filters:!(('$state':(store:appState),meta:(alias:!n,disabled:!f,index:'${index}',key:RequestId,negate:!f,params:(query:'${requestId}'),type:phrase),query:(match_phrase:(RequestId:'${requestId}'))))`,
            'grid:(columns:(LineNumber:(width:106),Mode:(width:68),Login:(width:86)))',
            `index:'${index}'`,
            'interval:auto',
            'query:(language:kuery,query:\'\')',
            'sort:!(!(\'@timestamp\',asc),!(LineNumber,asc))'
        ].join(',');
        const origin = window.location.origin;
        const path = window.location.pathname;
        const hash = `#/?_g=${g}&_a=(${a})`;
        window.open(`${origin}${path}${hash}`);
    }
}

function patchLoginPage() {
    const onLoginPageLoaded = getWaitNodeCallback(
        node => node.classList !== undefined && node.classList.contains('loginWelcome'),
        node => {
            const vaultLink = createVaultLink();
            const span = document.createElement('span');
            span.className = 'euiCallOutHeader__title';
            span.textContent = 'Users can be found in ';
            span.appendChild(vaultLink);
            const div1 = document.createElement('div');
            div1.className = 'euiCallOutHeader';
            div1.appendChild(span);
            const div2 = document.createElement('div');
            div2.className = 'euiCallOut euiCallOut--primary euiCallOut--small';
            div2.dataset.testSubj = 'loginInfoMessage';
            div2.setAttribute('role', 'status');
            div2.appendChild(div1);
            const spacer = document.createElement('div');
            spacer.className = 'euiSpacer euiSpacer--l';
            const loginBody = node.querySelector('.loginWelcome-body > div > div');
            loginBody.prepend(div2, spacer);
        },
        false
    );

    new MutationObserver(onLoginPageLoaded).observe(document.body, subtreeChildOptions);

    function createVaultLink() {
        const secretId = window.location.host.indexOf('crm-test') === -1 ? 'sec-01fggqftkms1zhfj3mvfwch5rh' : 'sec-01f9qb9ktx25vzfjzscmtffywb';
        const a = document.createElement('a');
        a.href = `https://yav.yandex-team.ru/secret/${secretId}/explore/version/head`;
        a.textContent = 'vault';
        a.style.textDecoration = 'underline';
        a.style.color = 'red';
        a.target = '_blank';
        return a;
    }
}

function getWaitNodeCallback(nodeSelector, action, stopOnFirst) {
    return function (mutations, observer) {
        const addedNodesLists = mutations
            .map(m => m.addedNodes)
            .filter(nl => nl.length > 0);
        for (let nodeList of addedNodesLists) {
            for (let node of nodeList) {
                if (nodeSelector(node)) {
                    if (stopOnFirst) {
                        observer.disconnect();
                    }
                    action(node);
                }
            }
        }
    };
}
