import zipfile
import re
import argparse

MANIFEST_FILE_FULLNAME = 'META-INF/MANIFEST.MF'


def main():
    parser = argparse.ArgumentParser(description='Modify classpath for log4j plugins support')
    parser.add_argument('--log4jversion', required=True)
    parser.add_argument('--jarfile', required=True)
    args = parser.parse_args()

    with zipfile.ZipFile(args.jarfile, mode='a') as jar:
        manifest = jar.read(MANIFEST_FILE_FULLNAME).decode('utf-8')
        manifest = re.sub('Class-Path: .*', f'Class-Path: log4j-core-{args.log4jversion}.jar log4j-layout-template-json-{args.log4jversion}.jar', manifest)
        jar.writestr('META-INF/MANIFEST.MF', manifest)
