package ru.yandex.crm.infra.logbroker.hoover.config

data class ApiConfig(
    val url: String,
    val ignoreErrors: Boolean,
    val tvm: TvmConfig,
    val sendBatches: Boolean,
    val batchMaxSize: Int,
    val resendMaxOffset: Int
) {
    companion object {
        private const val URL_KEY = "API_HANDLER_URL"
        private const val BATCHES_KEY = "API_SEND_BATCHES"
        private const val BATCH_MAX_SIZE_KEY = "API_BATCH_MAX_SIZE"
        private const val IGNORE_ERRORS_KEY = "API_IGNORE_HANDLER_ERRORS"
        private const val RESEND_MAX_OFFSET_KEY = "RESEND_MAX_OFFSET"

        fun fromEnvironmentVariables(): ApiConfig {
            val url = System.getenv(URL_KEY) ?: throw IllegalArgumentException("$URL_KEY is not specified")
            val ignoreErrors = System.getenv(IGNORE_ERRORS_KEY)?.toBoolean() ?: false
            val sendBatches = System.getenv(BATCHES_KEY)?.toBoolean() ?: false
            val batchMaxSize = System.getenv(BATCH_MAX_SIZE_KEY)?.toInt() ?: 8192
            val resendMaxOffset = System.getenv(RESEND_MAX_OFFSET_KEY)?.toInt() ?: 600
            val tvm = TvmConfig.fromEnvironmentVariables("API", "target")
            return ApiConfig(url, ignoreErrors, tvm, sendBatches, batchMaxSize, resendMaxOffset)
        }
    }
}

