package ru.yandex.crm.infra.logbroker.hoover.config

data class LogbrokerConfig(
    val installation: String,
    val database: String,
    val topics: Collection<String>,
    val consumer: String,
    val maxMessagesCount: Int,
    val tvm: TvmConfig
) {
    companion object {
        private const val INSTALLATION_KEY = "LOGBROKER_INSTALLATION"
        private const val DATABASE_KEY = "LOGBROKER_DATABASE"
        private const val TOPICS_KEY = "LOGBROKER_TOPICS"
        private const val CONSUMER_KEY = "LOGBROKER_CONSUMER"
        private const val MAX_COUNT_KEY = "LOGBROKER_MAX_COUNT"

        fun fromEnvironmentVariables(): LogbrokerConfig {
            val installation = System.getenv(INSTALLATION_KEY) ?: "logbroker.yandex.net:2135"
            val database = System.getenv(DATABASE_KEY) ?: "/Root"
            val topics = System.getenv(TOPICS_KEY) ?: throw IllegalArgumentException("$TOPICS_KEY is not specified")
            val consumer =
                System.getenv(CONSUMER_KEY) ?: throw IllegalArgumentException("$CONSUMER_KEY is not specified")
            val maxMessagesCount = System.getenv(MAX_COUNT_KEY)?.toInt() ?: 10
            val tvm = TvmConfig.fromEnvironmentVariables("LOGBROKER", "logbroker")
            return LogbrokerConfig(installation, database, topics.split(';'), consumer, maxMessagesCount, tvm)
        }
    }
}
