package ru.yandex.crm.infra.logbroker.hoover.config

data class TvmConfig(val selfAlias: String, val destAlias: String) {
    companion object {
        private const val SELF_ALIAS_KEY = "_TVM_SRC_ALIAS"
        private const val DEST_ALIAS_KEY = "_TVM_DST_ALIAS"

        fun fromEnvironmentVariables(prefix: String, defaultDest: String): TvmConfig {
            val selfAlias = System.getenv("$prefix$SELF_ALIAS_KEY") ?: "hoover"
            val destAlias = System.getenv("$prefix$DEST_ALIAS_KEY") ?: defaultDest
            return TvmConfig(selfAlias, destAlias)
        }
    }
}
