#!/bin/bash

ERROR_LIMIT=${1:-5000}

errcount=$(curl -s http://localhost:16301/status | grep ErrorsRate | awk '{print $2}')

echo "unified_agent error count: $errcount, limit: $ERROR_LIMIT"

if [ $errcount -gt $ERROR_LIMIT ];
then 
    >&2 echo "stopping unified_agent"
    exit 1
else
    echo "not enough errors to stop unified_agent"
    exit 0
fi
