import logging
import sys
import json

from apscheduler.schedulers.background import BackgroundScheduler
from flask import Flask, jsonify
from datetime import datetime

from .pymonitor.app import Pymonitor
from library.python.deploy_formatter import DeployFormatter

log_formatter = DeployFormatter()

errors_handler = logging.StreamHandler(sys.stderr)
errors_handler.setLevel(logging.WARN)
errors_handler.setFormatter(log_formatter)
others_handler = logging.StreamHandler(sys.stdout)
others_handler.setLevel(logging.DEBUG)
# others_handler.addFilter(lambda record: record.levelno <= logging.INFO)
others_handler.setFormatter(log_formatter)

root = logging.getLogger()
root.setLevel(logging.DEBUG)
root.addHandler(errors_handler)
root.addHandler(others_handler)

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
logging.getLogger("urllib3").setLevel(logging.WARNING)

logger.debug("Starting application")

app = Flask(__name__)

prefix = "crm"
suffix = "max"


class Context:
    pyMonitor = Pymonitor()

startAt = datetime.now()
sched = BackgroundScheduler(daemon=True)
sched.add_job(Context.pyMonitor.monitor_1min, 'interval', minutes=1, next_run_time=startAt)
sched.add_job(Context.pyMonitor.monitor_5min, 'interval', minutes=5, next_run_time=startAt)
sched.add_job(Context.pyMonitor.monitor_20min, 'interval', minutes=20, next_run_time=startAt)
sched.add_job(Context.pyMonitor.monitor_1hour, 'interval', minutes=60, next_run_time=startAt)
sched.add_job(Context.pyMonitor.monitor_1day, 'interval', minutes=1440, next_run_time=startAt)
sched.start()


@app.route('/stat')
def stat():
    logger.debug(f"/stat requested. monitorCount: {len(Context.pyMonitor.monitor_results.keys())}")
    yasm_result = [(f"{prefix}.{key}_{suffix}", val) for key, val in Context.pyMonitor.monitor_results.items()]

    return jsonify(yasm_result)


@app.route("/ping")
def ping():
    return "OK"


def get_metric(name, value):
    return {
        'labels': {
            "pymonitor": name.replace(".", "__")
            },
        "value": value
    }


@app.route('/solomon')
def solomon():
    logger.debug(f"/solomon requested.  monitorCount: {len(Context.pyMonitor.monitor_results.keys())}")
    monitor_results = Context.pyMonitor.monitor_results
    metrics = [get_metric(key, val) for key, val in monitor_results.items()]
    data = {'metrics': metrics}
    response = app.response_class(
        response=json.dumps(data),
        mimetype='application/json'
    )

    return response


def main():
    app.run(host='::', port=80)
