import os


class Config:
    ENVIRONMENT = os.environ.get("CRM_MONITOR__ENV")

    # format "crm/crm@tcrm.yandex.ru"
    CONNECTION_STRING = str(os.environ.get("CRM_MONITOR__ORA_USER")) + "@" + \
                        str(os.environ.get("CRM_MONITOR__ORA_HOST"))

    GRAPHITE_HOST = os.environ.get("CRM_MONITOR__GRAPHITE_HOST")
    GRAPHITE_PORT = int(os.environ.get("CRM_MONITOR__GRAPHITE_PORT") or "42000")

    MAIL_TOKEN_TCRM = os.environ.get("CRM_MONITOR__MAIL_TOKEN_TCRM")
    MAIL_TOKEN_ROBOT_TCRM = os.environ.get("CRM_MONITOR__MAIL_TOKEN_ROBOT_TCRM")

    ELASTICSEARCH_HOST = os.environ.get("CRM_MONITOR__ES_HOSTS")
    ELASTICSEARCH_USER = os.environ.get("CRM_MONITOR__ES_USER")
    ELASTICSEARCH_PASSWORD = os.environ.get("CRM_MONITOR__ES_PASSWORD")
