import json
import logging

from .consts import MonitorConsts
from ..utils.es_client import Es
from ..utils.stopwatch import Stopwatch


class ElasticMonitorGroup:

    def __init__(self, hosts, user, password, signal):
        self.logger = logging.getLogger(self.__class__.__name__)
        self.hosts = hosts
        self.user = user
        self.password = password
        self.signal = signal

    def monitor_1min(self):
        health_dict = self.cluster_health()
        return {**health_dict}

    def monitor_5min(self):
        return {}

    def monitor_json(self, json_mons):
        result = {}
        for mon in json_mons:
            mon_dict = self.exec_json(mon.index_name, mon.body_json, mon.exec_result)
            if mon_dict is not None:
                for key, val in mon_dict.items():
                    result[key] = val
        return result

    def cluster_health(self):
        es = Es(self.hosts, self.user, self.password).es()
        health = es.cluster.health()["active_shards_percent_as_number"]
        health = health / 100
        health = - health ** 5 + 1
        self.signal.send(MonitorConsts.es_health, health)
        return {MonitorConsts.es_health: health}

    def exec_json(self, index, json_body, exec_result):
        es = Es(self.hosts, self.user, self.password).es()
        queryHash = hash(json_body)
        self.logger.debug(f"Executing es query. queryHash: {queryHash}, json_body: {json_body}")
        query = json.loads(json_body)

        sw = Stopwatch()
        response = es.search(
            index=index,
            body=query
        )  # Using further in the exec func
        self.logger.info(f"Es response received. queryHash: {queryHash}, elapsed: {sw.elapsed()}ms, response: {response}")

        self.logger.debug(f"Executing response. queryHash: {queryHash}, cmd: {exec_result}")
        result_dict = {}
        try:
            exec(exec_result)  # Filling in a dict variable
        except Exception:
            self.logger.exception(f"Error during external func execution. queryHash: {queryHash}")

        if result_dict is None:
            result_dict = {}
        return result_dict
