from .monitor import Monitor
from ..utils.ora_client import Oracle


class OraMonitor(Monitor):

    def __init__(self, connection_string, name, sql):
        super().__init__(name)
        self.sql = sql
        self.connection_string = connection_string

    def monitor(self):
        ora = Oracle(self.connection_string)
        rows = ora.query(self.sql, lambda row: row[0])
        return rows[0]
