import logging
from elasticsearch import Elasticsearch

from .stopwatch import Stopwatch


class Es:
    def __init__(self, hosts, user, password):
        self.logger = logging.getLogger(self.__class__.__name__)
        self.hosts = hosts.split(",")
        self.user = user
        self.password = password

    def es(self):
        return Elasticsearch(
            self.hosts,
            http_auth=(self.user, self.password),
            scheme="https",
        )

    def info(self):
        es = self.es()
        sw = Stopwatch()
        info = es.info()
        self.logger.info(f"Executed 'info'. elapsed: {sw.elapsed()}ms")
        return info

    def exec_body(self, index, body):
        es = self.es()
        sw = Stopwatch()
        response = es.search(index=index, body=body)
        self.logger.info(f"Executed body. elapsed: {sw.elapsed()}ms")
        return response

    def exec_search(self, search):
        sw = Stopwatch()
        response = search.execute()
        self.logger.info(f"Es response received. elapsed: {sw.elapsed()}")
        return response
