import datetime
import logging


class EsLogs:
    def __init__(self, hosts):
        self.logger = logging.getLogger(self.__class__.__name__)
        self.hosts = hosts

    @staticmethod
    def index_name(name, minus_week):
        today = datetime.datetime.today()
        today_w = today - datetime.timedelta(days=minus_week * 7)
        dt_part = today_w.isocalendar()
        index_name = f"{name}{dt_part[0]}w{dt_part[1]:02d}*"
        return index_name
