import logging
import time
import datetime
import socket

from ...config import Config
from .signal import Signal


class GraphiteClient(Signal):

    def __init__(self, host, port):
        self.logger = logging.getLogger(self.__class__.__name__)
        self.host = host
        self.port = port

    def internal_send(self, metric_name, value):
        if Config.ENVIRONMENT != "stable":
            metric_name = metric_name.replace("crm_yandex_ru", "crm_yandex_ru.test")
        tm = datetime.datetime.utcnow()
        tmu = int(time.mktime(tm.timetuple()))
        s = socket.socket(socket.AF_INET6, socket.SOCK_STREAM)
        s.connect((self.host, self.port))
        s.send("{0} {1} {2}\n".format(metric_name, value, tmu).encode())
        s.close()
        self.logger.info(f"Metric sent to graphite. metric_name: {metric_name}, value: {value}, tmu: {tmu}, utc: {tm}")

    def send(self, metric_name, value, metric_time=None):
        # self.logger.debug(f"Sending to graphite. Metric: {metric_name}, value: {value}")
        self.internal_send(metric_name, value)
