import logging
import requests
import json

from .tvm_client import TvmClient


class MailClient(object):

    def __init__(self, login, token):
        self.logger = logging.getLogger(self.__class__.__name__)
        self._login = login
        self._token = token

    def new_count(self, folder_name):
        tvm = TvmClient()
        mail_url = \
            "https://intapicorp.mail.yandex.net/get-folders/v1?client_name=CRM-pymon&client_version=1.0&lang=en"
        auth_header = {
            "X-Ya-Service-Ticket": tvm.get_service_ticket("mailapi"),
            "X-Ya-User-Ticket": tvm.get_user_ticket(self._token)
        }

        response = requests.get(mail_url, headers=auth_header, verify=False)
        try:
            data = json.loads(response.content)
            new_count = -1
            for folder in data["folders"]:
                if folder['symbol'] == folder_name:
                    new_count = int(folder['unreadMessagesCount'])
                    break
            if new_count == -1:
                raise Exception("No folders in response")
            return new_count
        except Exception:
            self.logger.exception(f"Error during requesting new_count."
                                  f" login: {self._login}. response: {response.content}")
