import cx_Oracle
import logging

from .stopwatch import Stopwatch


class Oracle(object):

    def __init__(self, connection_string):
        self.logger = logging.getLogger(self.__class__.__name__)
        self.connection_string = connection_string
        self.db = None
        self.cursor = None

    def connect(self):
        self.logger.debug("Connecting to Oracle")
        self.db = cx_Oracle.connect(self.connection_string)
        self.cursor = self.db.cursor()

    def disconnect(self):
        try:
            if self.cursor is not None:
                self.cursor.close()
            if self.db is not None:
                self.db.close()
            self.logger.debug("Disconnected from Oracle")
        except cx_Oracle.DatabaseError as ex:
            self.logger.error(f"Error on closing ora. ex: {ex}")

    def query(self, sql, parser, args={}):
        try:
            self.connect()
            sw = Stopwatch()
            sqlHash = hash(sql)
            self.logger.debug(f"Executing query. sqlHash: {sqlHash}, sql: {sql}, args: {args}")
            self.cursor.execute(sql, args)
            self.logger.info(f"Query executed. sqlHash: {sqlHash}, elapsed: {sw.elapsed()}ms")
            rows = []
            for row in self.cursor:
                rows.append(parser(row))
            return rows
        finally:
            self.disconnect()

    def execute(self, sql, bindvars=None, commit=False):
        self.cursor.execute(sql, bindvars)

        if commit:
            self.db.commit()
