package ru.yandex.crm.library.kotlin.database

import org.apache.commons.dbcp2.BasicDataSource
import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.crm.library.kotlin.service.addOptions
import javax.sql.DataSource

fun HostBuilder.withDatabase(): HostBuilder = this.withModule(module {
    addOptions<DatabaseConfig>("database")
    single { createDbcpBasicDataSource(get()) } bind DataSource::class
})

private fun createDbcpBasicDataSource(config: DatabaseConfig) = BasicDataSource().apply {
    driverClassName = config.driver
    url = config.url
    username = config.user
    password = config.password
}
