package ru.yandex.crm.library.kotlin.database

import java.io.Serializable

interface Repository<EntityClass, IdClass : Serializable> {
    fun findOne(id: IdClass): EntityClass?
    fun findAll(): List<EntityClass>
    fun findAll(queryString: String, vararg params: Pair<String, *>): List<EntityClass>
    fun findOne(queryString: String, vararg params: Pair<String, *>): EntityClass?
    fun save(entity: EntityClass): EntityClass
    fun delete(id: IdClass)
    fun delete(entity: EntityClass)
}
