## Naming

1. Название абстрактного класса должно иметь суффикс `Base` (`LogModelBase`(). Исключения - расширение внешнего кода с другим неймингом.
2. Имя класса должно отражать его суть.
3. Схожие по назначению классы должны иметь одинаковые суффиксы в названии:
    - `Service` (`AuditorService`) - реализация сервиса, обслуживающего RPC запросы от пользователей. Слой представления;
    - `WebService` (`YaCallsWebService`) - реализация сервиса, обслуживающего REST запросы от пользователей. Слой представления;
    - `Manager` (`UserManager`) - отвечает за валидацию и преобразование данных перед сохранением. Слой бизнес логики;
    - `Repository` (`UserRepository`) - отвечает за работу с системой хранения (в частности, БД). Слой данных.
4. Если реализация интерфейса завязана на какую-то библиотеку, то название класса должно содержать название библиотеки:
    - `EntityRepository` - интерфейс;
    - `HibernateEntityRepository` - реализация интерфейса, завязанная на Hibernate;
    - `JooqEntityRepository` - реализация интерфейса, завязанная на jOOQ.
5. Единственная реализация, не привязанная к фреймворку, может называться как интерфейс с суффиксом `Impl` (`UserManagerImpl`).
6. Если существует (или в какой-то момент появилось) две или более реализаций, то их название должно отображать разницу. **Запрещено** называть версиями.
```
TimelineManager - интерфейс
MonolithTimelineManager - первая реализация. Изначально класс назывался TimelineManagerImpl. После появления второй реализации был переименован.
RealtimeTimelineManager - вторая реализация
DistributedTimelineManager - третья реализация
```
