package ru.yandex.crm.library.kotlin.database.hibernate

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.crm.library.kotlin.service.addOptions

fun HostBuilder.withHibernate(): HostBuilder = this.withModule(module {
    addOptions<HibernateConfig>("database.hibernate")
    single { HibernateSessionManagerImpl(get(), get(), getAll<HibernateSchema>().distinctBy { it.javaClass }) } bind HibernateSessionManager::class
})
