package ru.yandex.crm.library.kotlin.database.hibernate

import org.hibernate.Session
import ru.yandex.crm.library.kotlin.database.Repository
import java.io.Serializable

open class HibernateRepository<EntityClass, IdClass : Serializable>(
    protected val session: Session,
    protected val clazz: Class<EntityClass>
) : Repository<EntityClass, IdClass> {

    override fun findOne(id: IdClass): EntityClass? {
        return session.get(clazz, id)
    }

    override fun findAll(queryString: String, vararg params: Pair<String, *>): List<EntityClass> {
        val query = session.createQuery(queryString, clazz)
        params.forEach { (name, value) ->
            query.setParameter(name, value)
        }
        return query.resultList ?: listOf()
    }

    override fun findOne(queryString: String, vararg params: Pair<String, *>): EntityClass? {
        return findAll(queryString, *params).firstOrNull()
    }

    override fun save(entity: EntityClass): EntityClass {
        session.saveOrUpdate(entity)
        return entity
    }

    override fun delete(id: IdClass) {
        val entity = session.get(clazz, id)
        if (entity != null)
            session.delete(entity)
    }

    override fun delete(entity: EntityClass) {
        session.delete(entity)
    }

    override fun findAll(): List<EntityClass> {
        return findAll("from ${clazz.name}")
    }
}
