package ru.yandex.crm.library.kotlin.database.hibernate

import org.hibernate.SessionFactory
import org.hibernate.boot.registry.StandardServiceRegistryBuilder
import org.hibernate.cfg.Configuration
import org.hibernate.cfg.Environment
import javax.sql.DataSource

class HibernateSessionManagerImpl(
    private val config: HibernateConfig,
    private val dataSource: DataSource,
    schemas: Collection<HibernateSchema>
) : HibernateSessionManager {
    override lateinit var sessionFactory: SessionFactory

    init {
        refresh(schemas)
    }

    override fun refresh(schemas: Collection<HibernateSchema>, update: Boolean?) {
        val configuration = Configuration()
        val ddlAutoConfig = when (update) {
            true -> "update"
            false -> "none"
            else -> config.hbm2ddlAuto
        }
        configuration
            .setProperty(Environment.DIALECT, config.dialect)
            .setProperty(Environment.SHOW_SQL, config.showSql.toString())
            .setProperty(Environment.HBM2DDL_AUTO, ddlAutoConfig)

        schemas.forEach { schema ->
            schema.annotatedClasses.forEach { configuration.addAnnotatedClass(it) }
        }

        val serviceRegistry = StandardServiceRegistryBuilder()
            .applySettings(configuration.properties)
            .applySetting(Environment.DATASOURCE, dataSource)
            .build()
        sessionFactory = configuration.buildSessionFactory(serviceRegistry)
    }
}
