package ru.yandex.crm.library.kotlin.database.hibernate

import org.hibernate.Session
import org.koin.core.parameter.parametersOf
import org.koin.mp.KoinPlatformTools
import ru.yandex.crm.library.kotlin.database.Repository

inline fun <reified T : Repository<*, *>> Session.getRepository(): T {
    val koin = KoinPlatformTools.defaultContext().get()
    return koin.get(T::class) { parametersOf(this) }
}
