package ru.yandex.crm.library.kotlin.database.hibernate

import org.hibernate.Session
import org.hibernate.Transaction
import org.koin.mp.KoinPlatformTools

inline fun <reified T> HibernateSessionManager.withTransaction(action: Session.() -> T): T {
    var transaction: Transaction? = null
    var session: Session? = null
    return try {
        session = this.sessionFactory.openSession()
        transaction = session.beginTransaction()
        val result = action(session)
        transaction.commit()
        result
    } catch (e: Exception) {
        transaction?.rollback()
        throw e
    } finally {
        session?.close()
    }
}

inline fun <reified T> transaction(action: Session.() -> T): T {
    val koin = KoinPlatformTools.defaultContext().get()
    val sessionManager = koin.get<HibernateSessionManager>()
    return sessionManager.withTransaction(action)
}
