package ru.yandex.crm.library.kotlin.database.jooq

import org.jooq.Configuration
import org.jooq.SQLDialect
import org.jooq.conf.RenderQuotedNames
import org.jooq.conf.Settings
import org.jooq.impl.DefaultConfiguration
import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.library.kotlin.service.HostBuilder
import javax.sql.DataSource

fun HostBuilder.withJooq(): HostBuilder = this.withModule(module {
    single { createJooqConfiguration(get()) } bind Configuration::class
})

fun createJooqConfiguration(dataSource: DataSource) = DefaultConfiguration().apply {
    setDataSource(dataSource)
    setSQLDialect(SQLDialect.POSTGRES)
    setSettings(Settings().withRenderQuotedNames(RenderQuotedNames.EXPLICIT_DEFAULT_UNQUOTED))
}
