package ru.yandex.crm.library.kotlin.service

import com.typesafe.config.ConfigFactory
import org.koin.core.context.startKoin
import org.koin.core.logger.Level
import org.koin.core.module.Module
import org.koin.dsl.module
import org.koin.logger.slf4jLogger

class CrmHostBuilder(override val args: Array<String>) : HostBuilder {
    private val modules: MutableList<Module> = mutableListOf()

    override fun withModule(module: Module): CrmHostBuilder {
        modules.add(module)
        return this
    }

    override fun build(): Host {
        val koinApp = startKoin {
            // do not change level until Koin 3.2.0
            slf4jLogger(Level.ERROR)
            modules(modules)
        }
        return CrmHost(koinApp.koin)
    }

    fun withConfiguration(): CrmHostBuilder = withModule(module { single { ConfigFactory.load() } })

    fun withApplicationLifetime(): CrmHostBuilder = withModule(module { single { ApplicationLifetime() } })
}
