package ru.yandex.crm.library.kotlin.service

import java.util.concurrent.atomic.AtomicBoolean

class ShutdownHook(private val stopFunction: () -> Unit) : Thread("ShutdownHook") {
    private val shouldStop = AtomicBoolean(true)

    override fun run() {
        if (shouldStop.compareAndSet(true, false)) {
            stopFunction()
        }
    }
}
