package ru.yandex.crm.library.kotlin.service.web

import io.ktor.application.Application
import io.ktor.application.call
import io.ktor.response.respondText
import io.ktor.routing.get
import io.ktor.routing.routing
import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.crm.library.kotlin.service.Service

fun HostBuilder.withDefaultWebService(configure: ((WebHostBuilder) -> Unit)? = null): HostBuilder {
    val builder = CrmWebHostBuilder(args)
    configure?.invoke(builder)
    withModule(module { single { builder.build() } bind Service::class })
    return this
}

@Suppress("unused")
fun Application.pingModule() {
    routing {
        get("/ping") {
            call.respondText("pong")
        }
    }
}
