package ru.yandex.crm.library.kotlin.service.web

import io.ktor.server.engine.commandLineEnvironment
import io.ktor.server.engine.embeddedServer
import io.ktor.server.jetty.Jetty

open class CrmWebHostBuilder(private val args: Array<String>) : WebHostBuilder {
    private var bindExternal = false

    override fun bindExternalInterfaces(bindExternal: Boolean): WebHostBuilder {
        this.bindExternal = bindExternal
        return this
    }

    override fun build(): KtorService {
        val environment = commandLineEnvironment(args)
        val ktor = embeddedServer(Jetty, environment)
        return KtorService(ktor)
    }
}
