package ru.yandex.crm.library.kotlin.service.web

import io.ktor.server.engine.ApplicationEngine
import io.ktor.server.engine.addShutdownHook
import kotlinx.coroutines.coroutineScope
import ru.yandex.crm.library.kotlin.service.Service

class KtorService(private val engine: ApplicationEngine) : Service {
    override suspend fun start() {
        engine.addShutdownHook { }
        engine.start()
    }

    override suspend fun stop() = coroutineScope {
        engine.stop(1000, 5000)
    }
}
