import nirvana.job_context as nv
import json
import os
import urllib3
import logging
import sys

EC_SUCCESS = 0
EC_FIELD_MISSING = 1
EC_COMPLEX_ERROR = 2
EC_SEND_ERROR = 3

logging.basicConfig(stream=sys.stdout, level=logging.DEBUG,
                    format='%(asctime)s - %(name)s - %(levelname)s - %(message)s')
urllib3.disable_warnings()
space_token = os.environ.get('CRM_TOKEN')
url_part1 = os.environ.get('CRM_URL_PART1') or 'https://crm.yandex-team.ru/api/v0/issue/'
url_part2 = os.environ.get('CRM_URL_PART2') or '/mail'
post_headers = {'Authorization': 'OAuth ' + space_token, 'Content-Type': 'application/json'}
http = urllib3.PoolManager()


def post_mail(id, json_params):
    data = json.dumps(json_params)
    # create mail draft
    try:
        createResponse = http.request('POST', url_part1 + str(id) + url_part2, body=data, headers=post_headers)
        content = createResponse.data.decode('utf-8')
        if createResponse.status != 200:
            raise Exception('Invalid http response', createResponse.status, content)

        draft = json.loads(content)
        logging.debug("mail draft created")
        logging.debug(draft)
        mail_id = draft['mail_id']
        logging.debug(mail_id)
    except BaseException as e:
        logging.critical('create mail draft fails')
        logging.critical(e.args)
        raise

    # send mail draft
    try:
        sendResponse = http.request('POST', url_part1 + str(id) + url_part2 + "/" + str(mail_id) + "/send", body=data, headers=post_headers)
        content = createResponse.data.decode('utf-8')
        if sendResponse.status != 200:
            raise Exception('Invalid http response', sendResponse.status, content)

        send = json.loads(sendResponse.data.decode('utf-8'))
        logging.debug("mail sent")
        logging.debug(send)
    except BaseException as e:
        logging.critical('send mail draft fails')
        logging.critical(e.args)
        raise

    return draft

def process_mail(mail, posted_mails, failed_mails):
    if 'issue_id' not in mail:
        logging.critical('issue_id is missing')
        logging.critical(mail)
        return EC_FIELD_MISSING
    elif 'body' not in mail:
        logging.critical('body is missing')
        logging.critical(mail)
        return EC_FIELD_MISSING
    else:
        tdata = {}
        issue_id = 0
        for param in mail:
            if param == 'id':
                issue_id = mail['id']
            elif param == 'issue_id':
                issue_id = mail['issue_id']
            else:
                tdata.update({param: mail[param]})
        try:
            posted_mails.append(post_mail(issue_id, tdata))
        except BaseException as e:
            logging.critical('email is not sent')
            logging.critical(mail)
            logging.critical(e.args)
            failed_mails.append(issue_id)
            return EC_SEND_ERROR

    return EC_SUCCESS

if __name__ == '__main__':
    ctx = nv.context()
    inputs = ctx.get_inputs()
    output = ctx.get_outputs()
    fl = inputs.get('mails.json')
    out_file = output.get('output.json')
    out_file_errors = output.get('output_fails.json')
    return_code = EC_SUCCESS

    posted_mails = []
    failed_mails = []

    with open(fl, 'r') as json_data:
        json_read = json.loads(json_data.read())
        if isinstance(json_read, dict) is True:
            r = process_mail(json_read, posted_mails, failed_mails)
            if r != EC_SUCCESS:
                return_code = r
        else:
            for mail in json_read:
                r = process_mail(mail, posted_mails, failed_mails)
                if r != EC_SUCCESS:
                    if r != return_code:
                        return_code = EC_COMPLEX_ERROR
                    else:
                        return_code = r

    if 'out_file' in vars() and out_file:
        with open(out_file, 'w') as output_json:
            output_json.write(
                json.dumps(posted_mails, ensure_ascii=False, indent=4, separators=(',', ': '), sort_keys=False))

    if 'out_file_errors' in vars() and out_file_errors:
        with open(out_file_errors, 'w') as output_json:
            output_json.write(
                json.dumps(failed_mails, ensure_ascii=False, indent=4, separators=(',', ': '), sort_keys=False))
    
    exit(return_code) 
