const SURFWAX_GRID_URL = 'http://crm@sw.yandex-team.ru:80/v0';
const { CRM_TESTING_URL } = require('./tests/e2e/constants/envConstants');

module.exports = {

    sessionRequestTimeout: 150000,

    sets: {
        issues: {
            files: 'tests/e2e/modules/issue/issue.hermione.e2e.js',
            browsers: ['yaBro_issues']
            //browsers: ['debug']
        },
        tickets: {
            files: 'tests/e2e/modules/ticket/index.js',
            browsers: ['yaBro_tickets']
            //browsers: ['debug']
        },
        accounts: {
            files: 'tests/e2e/modules/account/index.js',
            browsers: ['yaBro_accounts']
            //browsers: ['debug']
        },
         mail: {
            files: 'tests/e2e/mail/index.js',
            browsers: ['yaBro_mail'],
            //browsers: ['debug']
         },
        accountHistory: {
            files: 'tests/e2e/modules/accountHistory/index.js',
            browsers: ['yaBro_accountHistory']
            //browsers: ['debug']
        },
        massmail: {
            files: 'tests/e2e/modules/massmail/index.js',
            browsers: ['yaBro_massmail']
            //browsers: ['debug']
        },
         categorizer: {
            files: 'tests/e2e/modules/categorizer/index.js',
            browsers: ['yaBro_categorizator']
            //browsers: ['debug']
         },
        //  planner: {
        //     files: 'tests/e2e/modules/planner/planner.hermione.e2e.js',
        //     browsers: ['yaBro_planner'],
        //     //browsers: ['debug']
        // },
    },

    browsers: {
        yaBro_tickets: {
            desiredCapabilities: {
                browserName: 'chrome',
                browserVersion: '22.3.0.127',
                'selenoid:options' : { enableVideo: true },
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 1,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,
            gridUrl: SURFWAX_GRID_URL
        },

        yaBro_issues: {
            desiredCapabilities: {
                browserName: 'chrome',
                browserVersion: '22.3.0.127',
                'selenoid:options' : { enableVideo: true },
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 1,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,
            gridUrl: SURFWAX_GRID_URL
        },

        yaBro_accounts: {
            desiredCapabilities: {
                browserName: 'chrome',
                browserVersion: '22.3.0.127',
                'selenoid:options' : { enableVideo: true },
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 1,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,
            gridUrl: SURFWAX_GRID_URL
        },

        yaBro_accountHistory: {
            desiredCapabilities: {
                browserName: 'chrome',
                browserVersion: '22.3.0.127',
                'selenoid:options' : { enableVideo: true },
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 1,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,
            gridUrl: SURFWAX_GRID_URL
        },

        yaBro_massmail: {
            desiredCapabilities: {
                browserName: 'chrome',
                browserVersion: '22.3.0.127',
                'selenoid:options' : { enableVideo: true },
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 1,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,
            gridUrl: SURFWAX_GRID_URL
        },

        yaBro_mail: {
            desiredCapabilities: {
                browserName: 'chrome',
                browserVersion: '22.3.0.127',
                'selenoid:options' : { enableVideo: true },
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 1,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,
            gridUrl: SURFWAX_GRID_URL
        },

        yaBro_categorizator: {
            desiredCapabilities: {
                browserName: 'chrome',
                browserVersion: '22.3.0.127',
                'selenoid:options' : { enableVideo: true },
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 1,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,
            gridUrl: SURFWAX_GRID_URL
        },

        yaBro_planner: {
            desiredCapabilities: {
                browserName: 'chrome',
                browserVersion: '22.3.0.127',
                'selenoid:options' : { enableVideo: true },
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 1,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,
            gridUrl: SURFWAX_GRID_URL
        },

        debug: {
            desiredCapabilities: {
                browserName: 'firefox',
            },
            windowSize: {
                width: 1600,
                height: 1000
            },
            retry: 0,
            waitTimeout: 20000,
            baseUrl: CRM_TESTING_URL,

        }

    },

    prepareBrowser: function(browser) {
        // common functions
        browser.addCommand(
            'chooseAccount',
            require('./tests/e2e/commands/chooseAccount.js')
        );
        browser.addCommand(
            'chooseMailAccount',
            require('./tests/e2e/commands/chooseMailAccount.js')
        );
        browser.addCommand(
            'createDraftMail',
            require('./tests/e2e/commands/createDraftMail.js')
        );
        browser.addCommand(
            'sendMail',
            require('./tests/e2e/commands/sendMail.js')
        );
        browser.addCommand(
            'sendAndFindMail',
            require('./tests/e2e/commands/sendAndFindMail.js')
        );
        browser.addCommand(
            'openFirstInboxMail',
            require('./tests/e2e/commands/openFirstInboxMail.js')
        );
        browser.addCommand(
            'isMailUnread',
            require('./tests/e2e/commands/isMailUnread.js')
        );
        browser.addCommand(
            'isMailImportant',
            require('./tests/e2e/commands/isMailImportant.js')
        );
        browser.addCommand(
            'getMailByText',
            require('./tests/e2e/commands/getMailByText.js')
        );
        browser.addCommand(
            'clearTextField',
            require('./tests/e2e/commands/clearTextField.js')
        );
        browser.addCommand(
            'getSecrets',
            require('./tests/e2e/commands/getSecrets.js')
        );
        browser.addCommand(
            'passportLogin',
            require('./tests/e2e/commands/passportLogin.js')
        );

        // ticket functions
        browser.addCommand(
            'createNewTicket',
            require('./tests/e2e/commands/tickets/createNewTicket.js')
        );
        browser.addCommand(
            'saveTicket',
            require('./tests/e2e/commands/tickets/saveTicket.js')
        );
        browser.addCommand(
            'addFollowerToTicket',
            require('./tests/e2e/commands/tickets/addFollowerToTicket.js')
        );
        browser.addCommand(
            'addMarkToTicket',
            require('./tests/e2e/commands/tickets/addMarkToTicket.js')
        );
        browser.addCommand(
            'linkStartrackTicket',
            require('./tests/e2e/commands/tickets/linkStartrackTicket.js')
        );
        browser.addCommand(
            'linkCrmTicket',
            require('./tests/e2e/commands/tickets/linkCrmTicket.js')
        );
        browser.addCommand(
            'addTimerToTicket',
            require('./tests/e2e/commands/tickets/addTimerToTicket.js')
        );
        browser.addCommand(
            'createSecondLineTicket',
            require('./tests/e2e/commands/tickets/createSecondLineTicket.js')
        );
        browser.addCommand(
            'setAssigneeInTicket',
            require('./tests/e2e/commands/tickets/setAssigneeInTicket.js')
        );
        browser.addCommand(
            'getAttributeValue',
            require('./tests/e2e/commands/tickets/getAttributeValue.js')
        );
        browser.addCommand(
            'writeOutMailFromTicket',
            require('./tests/e2e/commands/tickets/writeOutMailFromTicket.js')
        );
        browser.addCommand(
            'sortTickets',
            require('./tests/e2e/commands/tickets/sortTickets.js')
        );
        browser.addCommand(
            'findTicketInList',
            require('./tests/e2e/commands/tickets/findTicketInList.js')
        );

        // issues functions
        browser.addCommand(
            'createNewIssue',
            require('./tests/e2e/commands/issues/createNewIssue.js')
        );
        browser.addCommand(
            'writeCommentToIssue',
            require('./tests/e2e/commands/issues/writeCommentToIssue.js')
        );
        browser.addCommand(
            'setDeadlineInIssues',
            require('./tests/e2e/commands/issues/setDeadlineInIssues.js')
        );
        browser.addCommand(
            'createLinkedIssue',
            require('./tests/e2e/commands/issues/createLinkedIssue.js')
        );
        browser.addCommand(
            'addMarkToIssue',
            require('./tests/e2e/commands/issues/addMarkToIssue.js')
        );

        // planner functions
        browser.addCommand(
            'createActivityInTable',
            require('./tests/e2e/commands/planner/createActivityInTable.js')
        );
        browser.addCommand(
            'findActivityInTable',
            require('./tests/e2e/commands/planner/findActivityInTable.js')
        );

    },

    plugins: {
        'html-reporter/hermione':
            {
            enabled: true,
            path: './html-results'
            },
        '@yandex-int/hermione-surfwax-router':
            {
            enabled: Boolean(process.env.CI_SYSTEM)
            }
    }
};
